' Cette classe construit un assembly  la vole,
' ajoute une classe (avec une mthode)
' et sauve le tout sur disque.
Imports System.Reflection
Imports System.Reflection.Emit
Imports DotNetAssembly = System.Reflection.Assembly

public class MyAsmBuilder
    Public Sub CreateMyAsm(ByVal curAppDomain As AppDomain)

        ' Crer un nom pour l'assembly.
        Dim asmName As AssemblyName = New AssemblyName()
        asmName.Name = "MyAssembly"
        asmName.Version = New Version("1.0.0.0")

        ' Crer un assembly en mmoire.
        Dim asm As AssemblyBuilder _
         = curAppDomain.DefineDynamicAssembly(asmName, _
                   AssemblyBuilderAccess.Save)

        ' Ici, nous construisons un assembly en un seul
        ' fichier, donc le nom du module est le mme
        ' que celui de l'assembly.
        Dim myModule As ModuleBuilder = _
        asm.DefineDynamicModule("MyAssembly", "MyAssembly.dll")

        ' Dfinir une classe publique nomme "HelloWorld".
        Dim helloWorldClass As TypeBuilder = myModule.DefineType("MyAssembly.HelloWorld", _
              TypeAttributes.Public)

        ' Dfinir un membre publique de type String nomme "Msg":
        Dim msgField As FieldBuilder = helloWorldClass.DefineField("Msg", _
                Type.GetType("System.String"), _
                FieldAttributes.Public)

        ' Maintenant, cration de la mthode GetMsg:
        ' Public Function GetMsg() as String
        Dim getMsgMethod As MethodBuilder = _
         helloWorldClass.DefineMethod("GetMsg", MethodAttributes.Public, _
                Type.GetType("System.String"), Nothing)
        Dim methodIL As ILGenerator = getMsgMethod.GetILGenerator()
        methodIL.Emit(OpCodes.Ldarg_0)
        methodIL.Emit(OpCodes.Ldfld, msgField)
        methodIL.Emit(OpCodes.Ret)

        ' Cration de la mthode SayHello:
        ' Public Sub SayHello() 
        Dim sayHiMethod As MethodBuilder = _
         helloWorldClass.DefineMethod("SayHello", _
                MethodAttributes.Public, Nothing, Nothing)
        methodIL = sayHiMethod.GetILGenerator()
        methodIL.EmitWriteLine("Bonjour!")
        methodIL.Emit(OpCodes.Ret)

        ' Construire la classe HelloWorld.
        helloWorldClass.CreateType()

        ' Sauver l'assembly sur le disque.
        asm.Save("MyAssembly.dll")
    End Sub
End Class